\ProvidesClass{tibop-article}[2021-09-21]
\LoadClass[a4paper,parskip=half-,fontsize=11pt]{scrarticle}
%\KOMAoption{fonsize=12pt}

\RequirePackage[a4paper, top=0.98in, bottom=0.79in, left=0.98in, right=0.98in]{geometry}
\RequirePackage[english]{babel}
\RequirePackage[]{silence}
\WarningFilter{biblatex}{'babel/polyglossia'} %We are not interested in the warning about csquotes
\RequirePackage{graphicx}
\RequirePackage{tabularx}
\RequirePackage{enumitem}
\RequirePackage[labelsep=period]{caption}
\RequirePackage{xcolor}
\RequirePackage[colorlinks,urlcolor=blue,citecolor=brown]{hyperref}




\RequirePackage[
style=numeric,
backend=bibtex,
giveninits=true,
maxbibnames=6,
minbibnames=3,
isbn=false,
url=false,
doi=false,
eprint=false,
terseinits=false,
]{biblatex}
\newrobustcmd{\MakeTitleCase}[1]{%
  \ifthenelse{\ifcurrentfield{title}}%
    {\MakeSentenceCase{#1}}%
    {#1}}
\DeclareFieldFormat{titlecase}{\MakeTitleCase{#1}}

\DeclareFieldFormat{citetitle}{\mkbibemph{\MakeSentenceCase{#1}}}
\DeclareFieldFormat
  [article,inbook,incollection,inproceedings,patent,thesis,unpublished]
  {citetitle}{\mkbibquote{\MakeSentenceCase{#1}\isdot}}
\DeclareFieldFormat
  [suppbook,suppcollection,suppperiodical]
  {citetitle}{\MakeSentenceCase{#1}}

\DeclareFieldFormat[book]{titlecase}{\MakeCapital{#1}}
\DeclareFieldFormat[inproceedings,incollection]{booktitle}{\MakeCapital{#1}}

%\DeclareFieldFormat{labelnumberwidth}{\mkbibsuperscript{#1}}
\setlength{\biblabelsep}{5pt}

%\DeclareNameAlias{default}{family-given}
\renewcommand*{\revsdnamepunct}{}
\renewcommand*{\finalnamedelim}{\multinamedelim}
\DeclareFieldFormat[article,inproceedings]{title}{#1}
\renewbibmacro*{in:}{}

\renewbibmacro*{journal+issuetitle}{%
  \usebibmacro{journal}%
  \newunit
  \printfield{series}%
  \newunit
  \usebibmacro{date}%
  \setunit{\addsemicolon}%
  \usebibmacro{volume+number+eid}%
  \setunit{\addcolon\space}%
  \usebibmacro{issue}%
  \newunit}%




\DeclareFieldFormat[article,periodical]{number}{\mkbibparens{#1}}
\renewbibmacro*{volume+number+eid}{%
  \printfield{volume}%
  \printfield{number}%
  \setunit{\addcomma\space}%
  \printfield{eid}}

\renewcommand*{\bibpagespunct}{\addcolon}
\DeclareFieldFormat{pages}{#1}


\RequirePackage{ifthen}
\RequirePackage[headsepline]{scrlayer-scrpage}

% ==========[ FONT ]============================================================


%\RequirePackage{ifxetex}
%\ifxetex
%    \RequirePackage{fontspec}
%    \setmainfont{Arimo}
%\else
\RequirePackage[OT1]{fontenc}
%\RequirePackage[lf]{gandhi}
%    \renewcommand{\familydefault}{\sfdefault}
%\RequirePackage[T1]{fontenc}
%    \RequirePackage[utf8]{inputenc}
%\fi

%===========[ Constants ]==========================================================
\renewcommand{\and}{, }
\newcommand{\lastand}{, and }
%\newcommand{\affOne}{\textsuperscript{1}}
%\newcommand{\affTwo}{\textsuperscript{2}}
%\newcommand{\affThree}{\textsuperscript{3}}
%\newcommand{\affFour}{\textsuperscript{4}}
%\newcommand{\affFive}{\textsuperscript{5}}


\addto\captionsenglish{\renewcommand{\figurename}{Figure}}
\addto\captionsenglish{\renewcommand{\tablename}{Table}}
\RequirePackage{floatrow}	% Centers all flaots.
\floatsetup[table]{capposition=top} % For adjusting the position of the caption (default is below).

\defbibheading{references}{\section{References}\sloppy}

% \newcommand{\orcid}[1]{\href{https://orcid.org/#1}{\textsuperscript{[#1]}}}
%\newcommand{\orcid}[1]{\href{https://orcid.org/#1}{\textsuperscript{[https://orcid.org/#1]}}}
\pagenumbering{arabic}
\ofoot{\thepage}
%\setlength{\parskip}{0pt}
\setlist[1]{topsep=0pt,itemsep=-5pt}

%===========[ Variables ]==========================================================
\newcommand{\contribtitle}{set title with \textbackslash TIBtitle in preamble}
\newcommand{\contribtitleshort}{set short title with \textbackslash TIBtitleshort in preamble}
\newcommand{\contribsubtitle}{}
\newcommand{\affiliations}{set affiliation with {\ttfamily \textbackslash TIBaffiliations\{\textbackslash AffOne X\textbackslash\textbackslash\textbackslash AffTwo Y\}} in preamble}
\newcommand{\support}{specify support with {\ttfamily \textbackslash TIBsupport} in preamble}
\newcommand{\authorlist}{specify authorlist with {\ttfamily \textbackslash TIBauthorlist} in preamble}

%\newcommand{\conferencename}{set DOI with \textbackslash TIBconferencename}
%\newcommand{\sessionname}{set DOI with \textbackslash TIBconferencesession}
\newcommand{\articleDOI}{TIB-OP will set DOI with \textbackslash TIBdoi}
\newcommand{\submitteddate}{TIB-OP will set date with \textbackslash TIBdoi}
\newcommand{\accepteddate}{TIB-OP will set date with \textbackslash TIBdoi}
\newcommand{\publisheddate}{TIB-OP will set date with \textbackslash TIBdoi}

\newcommand{\authorheaderstring}{}
\newcommand{\conferenceheaderstring}{}

\newcommand{\keywords}{}
\newcommand{\emails}{}
\newcommand{\thisabstract}{}
\newcommand{\AMSsubj}{}

%===========[ Setters ]==========================================================
\newcommand{\TIBemails}[1]{\renewcommand{\emails}{#1}}
\newcommand{\TIBkeywords}[1]{\renewcommand{\keywords}{#1}}
\newcommand{\TIBabstract}[1]{\renewcommand{\thisabstract}{#1}}
\newcommand{\TIBAMSsubj}[1]{\renewcommand{\AMSsubj}{#1}}
%\newcommand{\TIBconferencename}[2][]{\renewcommand{\conferencename}{#2}\ifthenelse{\equal{#1}{}}{\renewcommand{\conferenceheaderstring}{#2}}{\renewcommand{\conferenceheaderstring}{#1}}}
%\newcommand{\TIBconferencesession}[1]{\renewcommand{\sessionname}{#1}}
\newcommand{\TIBdoi}[1]{\renewcommand{\articleDOI}{#1}}
\newcommand{\TIBsubmitteddate}[1]{\renewcommand{\submitteddate}{#1}}
\newcommand{\TIBaccepteddate}[1]{\renewcommand{\accepteddate}{#1}}
\newcommand{\TIBpublisheddate}[1]{\renewcommand{\publisheddate}{#1}}
\newcommand{\TIBauthor}[2][]{
    \author{#2}
    \ifthenelse{\equal{#1}{}}
        {
         \renewcommand{\authorheaderstring}{#2}
         }
         {\renewcommand{\authorheaderstring}{#1}}
}
\newcommand{\TIBaffiliations}[1]{\renewcommand{\affiliations}{#1}}
\newcommand{\TIBtitle}[1]{\renewcommand{\contribtitle}{#1}}
\newcommand{\TIBtitleshort}[1]{\renewcommand{\contribtitleshort}{#1}}
\newcommand{\TIBsubtitle}[1]{\renewcommand{\contribsubtitle}{#1}}
\newcommand{\TIBsupport}[1]{\renewcommand{\support}{#1}}
\newcommand{\TIBauthorlist}[1]{\renewcommand{\authorlist}{#1}}

\ohead{\authorheaderstring\quad\textbar\quad \contribtitleshort\hfill\includegraphics[trim = 600px 800px 580px 820px, clip, width=1.6cm]{Logo_DAE-Panel_short.jpg}}

%===========[ FORMAT ]==========================================================

\RedeclareSectionCommand[
    beforeskip=-10pt,
    afterskip=5pt,
font={\normalfont\Large\bfseries}
]{section}
\RedeclareSectionCommand[%
    beforeskip=-10pt,
    afterskip=5pt,
font={\normalfont\large\bfseries}
]{subsection}
\RedeclareSectionCommand[%
    beforeskip=-10pt,
    afterskip=5pt,
font={\normalfont\normalsize\bfseries}
]{subsubsection}
\RedeclareSectionCommand[%
    beforeskip=-10pt,
    afterskip=5pt,
font={\normalfont\itshape}
]{paragraph}

%\renewcommand*{\sectionformat}{}%no numbers
%\renewcommand*{\subsectionformat}{}%no numbers
%\renewcommand*{\subsubsectionformat}{}%no numbers
%\renewcommand*{\paragraphformat}{}%no numbers




\newcommand{\finalpage}{
~\\

\begin{minipage}{0.4\textwidth}\authorlist
\end{minipage}
}

\captionsetup{belowskip=0pt,skip=6pt,labelfont=bf}%justification=raggedright,singlelinecheck=false
\makeatletter
\renewcommand{\maketitle}{
\begin{minipage}{0.4\textwidth}
        \footnotesize\noindent
        {\textbf{DAE Panel}}\medskip\\
        %{\sessionname}\medskip\\
        {\articleDOI}\smallskip\\
        {Submitted: \submitteddate}\smallskip\\
        {Accepted: \accepteddate}\smallskip\\
        {Published: \publisheddate}\smallskip\\
\end{minipage}
\hfill
\begin{minipage}{0.4\textwidth}
~\\[-2cm]

\begin{flushright}\includegraphics[trim = 460px 770px 480px 625px, clip,width=6cm]{Logo_DAE-Panel.jpg}
\end{flushright}\end{minipage}

        {\textcopyright}\ Authors. This work is licensed under a \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International License}\medskip\\


\bigskip

\bigskip

\bigskip

    \begin{center}
        \LARGE\textbf{\contribtitle}\\\smallskip
        \Large{\contribsubtitle}
    \end{center}
    \begin{center}
    \normalsize{\textsc{\@author}}
\end{center}
%    \let\thefootnote\relax\footnote{\emails\\\affiliations\\\support}

\bigskip

\bigskip

\bigskip

%~\\[1mm]
%    \begin{center}
%        \affiliations
%    \end{center}~\\[2mm]
    \textbf{Abstract:} {\thisabstract}\\[1mm]
    \textbf{Keywords:} {\keywords}\\[1mm]
    \textbf{AMS Subject Classification (2020):} {\AMSsubj}\\[1mm]
    \thispagestyle{plain}
    %disable the following commands for inclusion in the header
%    \renewcommand{\orcid}[1]{}
%    \renewcommand{\affOne}{}
%    \renewcommand{\affTwo}{}
%    \renewcommand{\affThree}{}
%    \renewcommand{\affFour}{}
    \thispagestyle{empty}
    }


\makeatother
\endinput
